<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bend extends Model 
{

    protected $table = 'bends';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('k_factor', 'bend_type', 'bend_radius', 'bend_angle', 'panel_id');

    public function panel()
    {
        return $this->belongsTo('App\Models\Panel');
    }

}